/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.LeafState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.Group;
import javax.media.j3d.Light;
import javax.vecmath.Color3f;

public abstract class LightState
extends LeafState {
    private int boundingLeaf = 0;
    private int[] scope;

    public LightState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        super.writeObject(dataOutput);
        this.scope = new int[((Light)this.node).numScopes()];
        for (int i2 = 0; i2 < ((Light)this.node).numScopes(); ++i2) {
            this.scope[i2] = this.control.getSymbolTable().addReference(((Light)this.node).getScope(i2));
        }
        this.boundingLeaf = this.control.getSymbolTable().addReference(((Light)this.node).getInfluencingBoundingLeaf());
        Color3f color3f = new Color3f();
        ((Light)this.node).getColor(color3f);
        this.control.writeColor3f(dataOutput, color3f);
        dataOutput.writeBoolean(((Light)this.node).getEnable());
        dataOutput.writeInt(this.boundingLeaf);
        this.control.writeBounds(dataOutput, ((Light)this.node).getInfluencingBounds());
        dataOutput.writeInt(this.scope.length);
        for (int i3 = 0; i3 < this.scope.length; ++i3) {
            dataOutput.writeInt(this.scope[i3]);
        }
    }

    public void readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        ((Light)this.node).setColor(this.control.readColor3f(dataInput));
        ((Light)this.node).setEnable(dataInput.readBoolean());
        this.boundingLeaf = dataInput.readInt();
        ((Light)this.node).setInfluencingBounds(this.control.readBounds(dataInput));
        this.scope = new int[dataInput.readInt()];
        for (int i2 = 0; i2 < this.scope.length; ++i2) {
            this.scope[i2] = dataInput.readInt();
        }
    }

    public void buildGraph() {
        ((Light)this.node).setInfluencingBoundingLeaf((BoundingLeaf)this.control.getSymbolTable().getJ3dNode(this.boundingLeaf));
        for (int i2 = 0; i2 < this.scope.length; ++i2) {
            ((Light)this.node).addScope((Group)this.control.getSymbolTable().getJ3dNode(this.scope[i2]));
        }
        super.buildGraph();
    }
}

